package com.tangguo.framework.wxcp;

import lombok.RequiredArgsConstructor;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;


/**
 * 企业微信配置类
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@RequiredArgsConstructor
@Configuration
@EnableConfigurationProperties(WxCpProperties.class)
public class WxCpConfiguration {

    private final WxCpProperties properties;


    /**
     * 配置 WxCpService 实例
     */
    @Bean("mobileWxCpService")
    public WxCpService mobileWxCpService() {
        List<WxCpProperties.AppConfig> appConfigs = this.properties.getAppConfigs();
	    WxCpProperties.AppConfig appConfig = appConfigs.get(0);
	    WxCpDefaultConfigImpl configStorage = new WxCpDefaultConfigImpl();
        configStorage.setCorpId(this.properties.getCorpId());
        configStorage.setAgentId(appConfig.getAgentId());
        configStorage.setCorpSecret(appConfig.getSecret());
        configStorage.setToken(appConfig.getToken());
        configStorage.setAesKey(appConfig.getAesKey());
        WxCpService service = new WxCpServiceImpl();
        service.setWxCpConfigStorage(configStorage);
        return service;
    }


	/**
	 * 配置 WxCpService 实例
	 */
	@Bean("pcWxCpService")
	public WxCpService pcWxCpService() {
		List<WxCpProperties.AppConfig> appConfigs = this.properties.getAppConfigs();
		WxCpProperties.AppConfig appConfig = appConfigs.get(1);
		WxCpDefaultConfigImpl configStorage = new WxCpDefaultConfigImpl();
		configStorage.setCorpId(this.properties.getCorpId());
		configStorage.setAgentId(appConfig.getAgentId());
		configStorage.setCorpSecret(appConfig.getSecret());
		configStorage.setToken(appConfig.getToken());
		configStorage.setAesKey(appConfig.getAesKey());
		WxCpService service = new WxCpServiceImpl();
		service.setWxCpConfigStorage(configStorage);
		return service;
	}

}
