package com.tangguo.common.core.domain.entity;

import com.tangguo.common.annotation.Excel;
import com.tangguo.common.annotation.Excel.ColumnType;
import com.tangguo.common.annotation.Excel.Type;
import com.tangguo.common.annotation.Excels;
import com.tangguo.common.core.domain.BaseEntity;
import com.tangguo.common.xss.Xss;
import lombok.ToString;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * 用户对象 sys_user
 *
 * @author ruoyi
 */
@ToString
public class SysUser extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 用户ID
	 */
	@Excel(name = "用户序号", cellType = ColumnType.NUMERIC, prompt = "用户编号")
	private Long userId;

	/**
	 * 部门ID
	 */
	@Excel(name = "部门编号", type = Type.IMPORT)
	private Long deptId;

	/**
	 * 用户账号
	 */
	@Excel(name = "登录名称")
	private String userName;

	/**
	 * 用户昵称
	 */
	@Excel(name = "用户名称")
	private String nickName;

	/**
	 * 用户邮箱
	 */
	@Excel(name = "用户邮箱")
	private String email;

	/**
	 * 手机号码
	 */
	@Excel(name = "手机号码")
	private String phonenumber;

	/**
	 * 用户性别
	 */
	@Excel(name = "用户性别", readConverterExp = "0=男,1=女,2=未知")
	private String sex;

	/**
	 * 用户头像
	 */
	private String avatar;

	/**
	 * 密码
	 */
	private String password;

	/**
	 * 帐号状态（0正常 1停用）
	 */
	@Excel(name = "帐号状态", readConverterExp = "0=正常,1=停用")
	private String status;

	/**
	 * 删除标志（0代表存在 2代表删除）
	 */
	private String delFlag;

	/**
	 * 最后登录IP
	 */
	@Excel(name = "最后登录IP", type = Type.EXPORT)
	private String loginIp;

	/**
	 * 最后登录时间
	 */
	@Excel(name = "最后登录时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
	private Date loginDate;

	/**
	 * 部门对象
	 */
	@Excels({
			@Excel(name = "部门名称", targetAttr = "deptName", type = Type.EXPORT),
			@Excel(name = "部门负责人", targetAttr = "leader", type = Type.EXPORT)
	})
	private SysDept dept;

	/**
	 * 角色对象
	 */
	private List<SysRole> roles;

	/**
	 * 角色组
	 */
	private Long[] roleIds;

	/**
	 * 岗位组
	 */
	private Long[] postIds;

	/**
	 * 角色ID
	 */
	private Long roleId;

	/**
	 * 是否论坛管理员
	 */
	private Boolean isBbsAdmin = Boolean.FALSE;

	public SysUser() {

	}

	public SysUser(Long userId) {
		this.userId = userId;
	}

	public static boolean isAdmin(Long userId) {
		return userId != null && 1L == userId;
	}


	public boolean isBbsAdmin() {
		return isBbsAdmin;
	}

	public void setBbsAdmin(Boolean bbsAdmin) {
		isBbsAdmin = bbsAdmin;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public boolean isAdmin() {
		return isAdmin(this.userId);
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	@Xss(message = "用户昵称不能包含脚本字符")
	@Size(min = 0, max = 30, message = "用户昵称长度不能超过30个字符")
	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	@Xss(message = "用户账号不能包含脚本字符")
	@NotBlank(message = "用户账号不能为空")
	@Size(min = 0, max = 30, message = "用户账号长度不能超过30个字符")
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	@Email(message = "邮箱格式不正确")
	@Size(min = 0, max = 50, message = "邮箱长度不能超过50个字符")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@Size(min = 0, max = 11, message = "手机号码长度不能超过11个字符")
	public String getPhonenumber() {
		return phonenumber;
	}

	public void setPhonenumber(String phonenumber) {
		this.phonenumber = phonenumber;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(String delFlag) {
		this.delFlag = delFlag;
	}

	public String getLoginIp() {
		return loginIp;
	}

	public void setLoginIp(String loginIp) {
		this.loginIp = loginIp;
	}

	public Date getLoginDate() {
		return loginDate;
	}

	public void setLoginDate(Date loginDate) {
		this.loginDate = loginDate;
	}

	public SysDept getDept() {
		return dept;
	}

	public void setDept(SysDept dept) {
		this.dept = dept;
	}

	public List<SysRole> getRoles() {
		return roles;
	}

	public void setRoles(List<SysRole> roles) {
		this.roles = roles;
	}

	public Long[] getRoleIds() {
		return roleIds;
	}

	public void setRoleIds(Long[] roleIds) {
		this.roleIds = roleIds;
	}

	public Long[] getPostIds() {
		return postIds;
	}

	public void setPostIds(Long[] postIds) {
		this.postIds = postIds;
	}

	public Long getRoleId() {
		return roleId;
	}

	public void setRoleId(Long roleId) {
		this.roleId = roleId;
	}

}
