package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 动态投票选项对象 bbs_moment_vote_option
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_moment_vote_option")
@ApiModel(value = "BbsMomentVoteOption", description = "动态投票选项实体")
public class BbsMomentVoteOption extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 动态ID */
	@Excel(name = "动态ID")
	@ApiModelProperty("动态ID")
	private Long momentId;

	/** 选项类型：TEXT 文字、IMAGE 图片 */
	@Excel(name = "选项类型：TEXT 文字、IMAGE 图片")
	@ApiModelProperty("选项类型：TEXT 文字、IMAGE 图片")
	private String type;

	/** 选项名称 */
	@Excel(name = "选项名称")
	@ApiModelProperty("选项名称")
	private String name;

	/** 选项编码 */
	@Excel(name = "选项编码")
	@ApiModelProperty("选项编码")
	private String code;

	/** 图片地址 */
	@Excel(name = "图片地址")
	@ApiModelProperty("图片地址")
	private String imageUrl;

	/** 排序值（升序） */
	@Excel(name = "排序值", readConverterExp = "升=序")
	@ApiModelProperty("排序值（升序）")
	private Integer sort;

	/** 投票人数 */
	@Excel(name = "投票人数")
	@ApiModelProperty("投票人数")
	private Integer voteCount;

}
