package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsMomentVote;
import com.tangguo.mapper.BbsMomentVoteMapper;
import com.tangguo.service.IBbsMomentVoteService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 动态投票记录Service业务层处理
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Service
public class BbsMomentVoteServiceImpl extends ServiceImpl<BbsMomentVoteMapper, BbsMomentVote> implements IBbsMomentVoteService {

    @Resource
    private BbsMomentVoteMapper bbsMomentVoteMapper;


    /**
     * 查询用户投票记录数量
     *
     * @param momentId 动态Id
     * @param userName 用户名
     * @return 点赞记录
     */
    @Override
    public long getUserMomentVoteCount(Long momentId, String userName) {
        return this.count(
            Wrappers.lambdaQuery(BbsMomentVote.class)
                .eq(BbsMomentVote::getMomentId, momentId)
                .eq(BbsMomentVote::getUserName, userName)
        );
    }


    /**
     * 添加点赞记录
     *
     * @param momentId   动态Id
     * @param userName   用户名
     * @param optionCode 投票选项编码
     */
    @Override
    public void addMomentVoteCount(Long momentId, String userName, String optionCode) {
        BbsMomentVote newVote = new BbsMomentVote();
        newVote.setMomentId(momentId);
        newVote.setUserName(userName);
        newVote.setOptionCode(optionCode);
        this.save(newVote);
    }

}
