package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 动态评论记录对象 bbs_moment_comment
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_moment_comment")
@ApiModel(value = "BbsMomentComment", description = "动态评论记录实体")
public class BbsMomentComment extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** ID */
    @TableId(type= IdType.AUTO)
    @ApiModelProperty("ID")
    private Long id;

    /** 轻享内容ID */
    @Excel(name = "轻享内容ID")
    @ApiModelProperty("轻享内容ID")
    private Long momentId;

    /** 评论用户姓名 */
    @Excel(name = "评论用户姓名")
    @ApiModelProperty("评论用户姓名")
    private String nikeName;

    /** 评论用户名 */
    @Excel(name = "评论用户名")
    @ApiModelProperty("评论用户名")
    private String userName;

    /** 评论内容 */
    @Excel(name = "评论内容")
    @ApiModelProperty("评论内容")
    private String content;

    /** 评论图片地址（1-3张） */
    @Excel(name = "评论图片地址", readConverterExp = "1=-3张")
    @ApiModelProperty("评论图片地址（1-3张）")
    private String imgsUrl;

    /** 评论状态：0 删除、1 正常、2 隐藏 */
    @Excel(name = "评论状态：0 删除、1 正常、2 隐藏")
    @ApiModelProperty("评论状态：0 删除、1 正常、2 隐藏")
    private Integer status;

    /** 评论是否精选：0 否、1 是 */
    @Excel(name = "评论是否精选：0 否、1 是")
    @ApiModelProperty("评论是否精选：0 否、1 是")
    private Integer isFeatured;

    /** 父级评论ID（为空为评论，否则为回复。） */
    @Excel(name = "父级评论ID", readConverterExp = "为=空为评论，否则为回复。")
    @ApiModelProperty("父级评论ID（为空为评论，否则为回复。）")
    private Long parentId;

    /** 回复的用户姓名 */
    @Excel(name = "回复的用户姓名")
    @ApiModelProperty("回复的用户姓名")
    private String replyNikeName;

    /** 评论祖级路径（逗号分隔） */
    @Excel(name = "评论祖级路径", readConverterExp = "逗=号分隔")
    @ApiModelProperty("评论祖级路径（逗号分隔）")
    private String ancestorPath;

    /** 删除评论内容 */
    @Excel(name = "删除评论内容")
    @ApiModelProperty("删除评论内容")
    private String deleteComment;

    /**
     * 动态内容
     */
    @TableField(exist = false)
    private String momentContent;

    /**
     * 子评论和回复
     */
    @TableField(exist = false)
    private List<BbsMomentComment> comments;

}
