package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMoment;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.domain.vo.BbsUserMomentCountVO;

import java.util.List;

/**
 * 动态Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentService extends IService<BbsMoment> {

    /**
     * 查询动态列表
     *
     * @param bbsMoment 动态
     * @return 动态集合
     */
    List<BbsMoment> selectBbsMomentList(BbsMoment bbsMoment);


    /**
     * 查询用户动态相关统计数据
     *
     * @return 动态统计数据
     */
    BbsUserMomentCountVO getUserMomentCount();


    /**
     * 创建动态
     *
     * @param bo 动态
     */
    void createMoment(CreateMomentBO bo);

}
