package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentAttachment;
import com.tangguo.domain.bo.CreateMomentBO;

import java.util.List;

/**
 * 动态附件Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentAttachmentService extends IService<BbsMomentAttachment> {

	/**
	 * 查询动态附件
	 *
	 * @param momentId 动态Id
	 * @return 附件
	 */
	List<BbsMomentAttachment> getAttachments(Long momentId);


	/**
	 * 添加动态附件
	 *
	 * @param userName 用户名
	 * @param momentId 动态Id
	 * @param attachments 动态附件
	 */
	void addAttachments(String userName, Long momentId, List<CreateMomentBO.Attachment> attachments);


	/**
	 * 删除动态附件
	 *
	 * @param momentId 动态Id
	 */
	void deleteAttachments(Long momentId);

}
