package com.tangguo.domain.bo;

import lombok.Data;

import java.util.List;

/**
 *
 *
 * @author 谈笑
 * @createTime 2025-09-02 16:38:31 星期二
 */
@Data
public class CreateMomentBO {

	/** 动态内容 */
	private String content;

	/** 动态类型：IMAGE 图片动态、VIDEO 视频动态 */
	private String type;

	/** 话题名称（逗号分割） */
	private List<String> topicNames;

	/** 话题Ids（逗号分割） */
	private List<String> topicIds;

	/** 外部链接地址 */
	private String linkUrl;

	/** 动态附件地址 */
	private List<String> attachmentUrls;

	/** 是否开启评论：0 否、1 是 */
	private Integer isEnableComment;

	/** 是否精选评论：0 否、1 是 */
	private Integer isEnableFeaturedComment;

	/** 是否开启投票：0 否、1 是 */
	private Integer isEnableVote;

	/** 投票标题 */
	private String voteTitle;

	/** 投票选项类型：TEXT 文字、IMAGE 图片 */
	private String voteOptionType;

	/** 动态附件 */
	private List<Attachment> attachments;

	/** 动态投票选项 */
	private List<VoteOption> voteOptions;


	/**
	 * 动态附件
	 */
	@Data
	public static class Attachment {

		/** 附件名称 */
		private String name;

		/** 附件类型：图片 IMAGE、视频 VIDEO */
		private String type;

		/** 附件预览地址 */
		private String url;

		/** 文件扩展名：PNG、JPG、MP4 */
		private String fileExt;

	}

	/**
	 * 动态投票选项
	 */
	@Data
	public static class VoteOption {

		/** 选项类型：TEXT 文字、IMAGE 图片 */
		private String type;

		/** 选项名称 */
		private String name;

		/** 选项编码 */
		private String code;

		/** 图片地址 */
		private String imageUrl;

		/** 排序值 */
		private Integer sort;

	}

}
