package com.tangguo.framework.wxcp;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * 企业微信配置类
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@Data
@ConfigurationProperties(prefix = "wx.cp")
public class WxCpProperties {

	/**
	 * 设置企业微信的corpId
	 */
	private String corpId;

	/**
	 * 多应用配置
	 */
	private List<AppConfig> appConfigs;


	@Data
	public static class AppConfig {

		private String name;

		/**
		 * 设置企业微信应用的AgentId
		 */
		private Integer agentId;

		/**
		 * 设置企业微信应用的Secret
		 */
		private String secret;

		/**
		 * 设置企业微信应用的token
		 */
		private String token;

		/**
		 * 设置企业微信应用的EncodingAESKey
		 */
		private String aesKey;

	}

}
