package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 敏感词库对象 bbs_sensitive_word
 *
 * @author ruoyi
 * @date 2025-08-27
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_sensitive_word")
@ApiModel(value = "BbsSensitiveWord", description = "敏感词库实体")
public class BbsSensitiveWord extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 敏感词名称 */
	@Excel(name = "敏感词名称")
	@ApiModelProperty("敏感词名称")
	private String name;

	/** 排序值 */
	@Excel(name = "排序值")
	@ApiModelProperty("排序值")
	private Integer sort;

	/** 启用状态：0 禁用、1 启用 */
	@Excel(name = "启用状态：0 禁用、1 启用")
	@ApiModelProperty("启用状态：0 禁用、1 启用")
	private Integer enableStatus;

}
