package com.tangguo.service;

import java.util.List;
import java.util.Set;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsSensitiveWord;
import com.tangguo.domain.result.DataImportResult;
import org.springframework.web.multipart.MultipartFile;

/**
 * 敏感词库Service接口
 *
 * @author ruoyi
 * @date 2025-08-27
 */
public interface IBbsSensitiveWordService extends IService<BbsSensitiveWord> {

    /**
     * 查询敏感词
     *
     * @return 敏感词
     */
    Set<String> getDbWords();


    /**
     * 刷新缓存敏感词
     */
    void refreshCacheWords();


    /**
     * 查询敏感词库列表
     *
     * @param bbsSensitiveWord 敏感词库
     * @return 敏感词库集合
     */
    List<BbsSensitiveWord> selectBbsSensitiveWordList(BbsSensitiveWord bbsSensitiveWord);


    /**
     * 新增敏感词
     *
     * @param word 敏感词
     */
    void addWord(BbsSensitiveWord word);


    /**
     * 修改敏感词
     *
     * @param word 敏感词
     */
    void editWord(BbsSensitiveWord word);


    /**
     * 删除敏感词
     *
     * @param wordId 敏感词Id
     */
    void deleteWord(Long wordId);


    /**
     * 导入敏感词
     *
     * @param file 铭感词文件
     * @return 导入结果
     */
    DataImportResult<String> importWords(MultipartFile file);

}
