import request from '@/utils/request'

// 用户等级列表
export function listData(params) {
    return request({
        url: '/bbs/moment/grade/list',
        method: 'get',
        params
    })
}

// 用户等级详情
export function detailData(id) {
    return request({
        url: `/bbs/moment/grade/${id}`,
        method: 'get'
    })
}

// 新增用户等级
export function addData(data) {
    return request({
        url: '/bbs/moment/grade',
        method: 'post',
        data
    })
}

// 修改用户等级
export function editData(data) {
    return request({
        url: '/bbs/moment/grade',
        method: 'put',
        data
    })
}


// 删除用户等级
export function delData(id) {
    return request({
        url: `/bbs/moment/grade/${id}`,
        method: 'delete'
    })
}