package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.domain.BbsTopic;
import com.tangguo.service.IBbsTopicService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 话题Controller
 *
 * @author ruoyi
 * @date 2025-08-27
 */
@Api(tags = "话题管理")
@RestController
@RequestMapping("/bbs/moment/topic")
public class BbsTopicController extends BaseController {

	@Resource
	private IBbsTopicService bbsTopicService;


	/**
	 * 查询话题列表
	 */
	@ApiOperation("查询话题列表")
	@PreAuthorize("@ss.hasPermi('topic:topic:list')")
	@GetMapping("/list")
	public TableDataInfo list(BbsTopic bbsTopic) {
		startPage();
		List<BbsTopic> list = bbsTopicService.selectBbsTopicList(bbsTopic);
		return getDataTable(list);
	}


	/**
	 * 获取话题详细信息
	 */
	@ApiOperation("获取话题详细信息")
	@PreAuthorize("@ss.hasPermi('topic:topic:query')")
	@GetMapping(value = "/{id}")
	public AjaxResult getInfo(@PathVariable("id") Long id) {
		return success(bbsTopicService.getById(id));
	}


	/**
	 * 新增话题
	 */
	@ApiOperation("新增话题")
	@PreAuthorize("@ss.hasPermi('topic:topic:add')")
	@Log(title = "话题", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@RequestBody BbsTopic bbsTopic) {
		this.bbsTopicService.addTopic(bbsTopic);
		return AjaxResult.success();
	}


	/**
	 * 修改话题
	 */
	@ApiOperation("修改话题")
	@PreAuthorize("@ss.hasPermi('topic:topic:edit')")
	@Log(title = "话题", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@RequestBody BbsTopic bbsTopic) {
		this.bbsTopicService.editeTopic(bbsTopic);
		return AjaxResult.success();
	}


	/**
	 * 修改话题
	 */
	@ApiOperation("修改话题")
	@PreAuthorize("@ss.hasPermi('topic:topic:edit')")
	@Log(title = "话题", businessType = BusinessType.UPDATE)
	@PutMapping("/top")
	public AjaxResult top(@RequestBody BbsTopic bbsTopic) {
		this.bbsTopicService.topTopic(bbsTopic);
		return AjaxResult.success();
	}


	/**
	 * 删除话题
	 */
	@ApiOperation("删除话题")
	@PreAuthorize("@ss.hasPermi('topic:topic:remove')")
	@Log(title = "话题", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
	public AjaxResult remove(@PathVariable Long id) {
		this.bbsTopicService.deleteTopic(id);
		return AjaxResult.success();
	}

}
