package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 动态投票记录对象 bbs_moment_vote
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_moment_vote")
@ApiModel(value = "BbsMomentVote", description = "动态投票记录实体")
public class BbsMomentVote extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 动态ID */
	@Excel(name = "动态ID")
	@ApiModelProperty("动态ID")
	private Long momentId;

	/** 投票用户名 */
	@Excel(name = "投票用户名")
	@ApiModelProperty("投票用户名")
	private String userName;

	/** 投票选项编码 */
	@Excel(name = "投票选项编码")
	@ApiModelProperty("投票选项编码")
	private String optionCode;

}
