package com.tangguo.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tangguo.common.core.domain.entity.SysDept;
import com.tangguo.domain.BbsMoment;
import com.tangguo.domain.bo.QueryMomentBO;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.domain.vo.BbsUserMomentCountVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 动态Mapper接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface BbsMomentMapper extends BaseMapper<BbsMoment> {

	List<BbsMoment> selectBbsMomentList(@Param("moment") BbsMoment moment);

	List<String> selectBbsMomentDepts(@Param("deptIds") String[] deptIds);


	BbsUserMomentCountVO selectUserMomentCount(@Param("userName") String userName);


	List<BbsMomentListVO> selectUserMoments(@Param("userName") String userName, @Param("content") String content);


	List<BbsMomentListVO> selectMoments(@Param("userName") String userName, @Param("bo") QueryMomentBO bo);


	BbsMomentListVO selectMomentDetail(@Param("momentId") Long momentId, @Param("userName") String userName);


	int incrMomentLikeCount(@Param("momentId") Long momentId, @Param("count") int count);


	int decrMomentLikeCount(@Param("momentId") Long momentId, @Param("count") int count);


	int incrMomentCommentCount(@Param("momentId") Long momentId, @Param("count") int count);


	int decrMomentCommentCount(@Param("momentId") Long momentId, @Param("count") int count);


	int incrMomentVoteCount(@Param("momentId") Long momentId, @Param("count") int count);


	int decrMomentVoteCount(@Param("momentId") Long momentId, @Param("count") int count);

}
