package com.tangguo.domain.bo;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 *
 *
 * @author 谈笑
 * @createTime 2025-09-04 15:28:48 星期四
 */
@Data
public class CommentMomentBO {

	/**
	 * 动态Id
	 */
	@NotNull(message = "动态Id不能为空")
	private Long momentId;

	/**
	 * 回复评论Id
	 */
	private Long parentId;

	/**
	 * 评论内容
	 */
	@NotBlank(message = "评论内容不能为空")
	@Length(max = 200, message = "评论内容字符长度错误")
	private String content;

}
