package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsTopic;
import com.tangguo.domain.bo.CreateTopicBO;
import com.tangguo.domain.vo.BbsTopicListVO;

import java.util.List;

/**
 * 话题Service接口
 *
 * @author ruoyi
 * @date 2025-08-27
 */
public interface IBbsTopicService extends IService<BbsTopic> {

    /**
     * 查询话题列表
     *
     * @param bbsTopic 话题
     * @return 话题集合
     */
    List<BbsTopic> selectBbsTopicList(BbsTopic bbsTopic);


    /**
     * 新增话题
     *
     * @param topic 话题
     */
    void addTopic(BbsTopic topic);


    /**
     * 修改话题
     *
     * @param topic 话题
     */
    void editeTopic(BbsTopic topic);


    /**
     * 置顶话题
     *
     * @param topic 话题
     */
    void topTopic(BbsTopic topic);


    /**
     * 删除话题
     *
     * @param topicId 话题Id
     */
    void deleteTopic(Long topicId);


    /**
     * 查询选择话题
     *
     * @param name 话题名称
     * @return 话题
     */
    List<BbsTopicListVO> getSelectTopics(String name);


    /**
     * 刷新热搜话题
     */
    void refreshRankingTopic();


    /**
     * 查询热搜话题
     *
     * @param name 话题名称
     * @return 话题
     */
    List<BbsTopicListVO> getRankingTopic(String name);


    /**
     * 创建话题
     *
     * @param bo 话题
     */
    BbsTopicListVO createTopic(CreateTopicBO bo);

}
