package com.tangguo.controller.pc;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.utils.poi.ExcelUtil;
import com.tangguo.domain.BbsMoment;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.service.IBbsMomentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 动态Controller
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Api(tags="动态管理")
@RestController
@RequestMapping("/bbs/moment")
public class BbsMomentController extends BaseController {

    @Resource
    private IBbsMomentService bbsMomentService;


    /**
     * 查询动态列表
     */
    @ApiOperation("查询动态列表")
    @PreAuthorize("@ss.hasPermi('bbs:moment:list')")
    @GetMapping("/list")
    public TableDataInfo list(BbsMoment bbsMoment) {
        startPage();
        List<BbsMoment> list = bbsMomentService.selectBbsMomentList(bbsMoment);
        return getDataTable(list);
    }


    /**
     * 导出动态列表
     */
    @ApiOperation("导出动态列表")
    @PreAuthorize("@ss.hasPermi('points:points:export')")
    @Log(title = "导出动态列表", businessType = BusinessType.EXPORT)
    @PostMapping("/list/export")
    public void export(HttpServletResponse response, BbsMoment bbsMoment) {
        List<BbsMoment> list = bbsMomentService.selectBbsMomentList(bbsMoment);
        ExcelUtil<BbsMoment> util = new ExcelUtil<>(BbsMoment.class);
        util.exportExcel(response, list, "动态数据");
    }


    /**
     * 获取动态详细信息
     */
    @ApiOperation("获取动态详细信息")
    @PreAuthorize("@ss.hasPermi('bbs:moment:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        BbsMomentListVO dbMoment = this.bbsMomentService.selectBbsMoment(id);
        return success(dbMoment);
    }


    /**
     * 删除动态
     */
    @ApiOperation("删除动态")
    @PreAuthorize("@ss.hasPermi('bbs:moment:remove')")
    @Log(title = "动态", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
    public AjaxResult remove(@PathVariable Long id) {
        this.bbsMomentService.deleteMoment(id);
        return AjaxResult.success();
    }

}
