package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 动态附件对象 bbs_moment_attachments
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_moment_attachment")
@ApiModel(value = "BbsMomentAttachments", description = "动态附件实体")
public class BbsMomentAttachment extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 动态ID */
	@Excel(name = "动态ID")
	@ApiModelProperty("动态ID")
	private Long momentId;

	/** 用户名 */
	@Excel(name = "用户名")
	@ApiModelProperty("用户名")
	private String userName;

	/** 附件名称 */
	@Excel(name = "附件名称")
	@ApiModelProperty("附件名称")
	private String name;

	/** 附件类型：图片 IMAGE、视频 VIDEO */
	@Excel(name = "附件类型：图片 IMAGE、视频 VIDEO")
	@ApiModelProperty("附件类型：图片 IMAGE、视频 VIDEO")
	private String type;

	/** 附件预览地址 */
	@Excel(name = "附件预览地址")
	@ApiModelProperty("附件预览地址")
	private String url;

}
