package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMoment;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.domain.bo.LikeMomentBO;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.domain.vo.BbsUserMomentCountVO;

import java.util.List;

/**
 * 动态Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentService extends IService<BbsMoment> {

    /**
     * 查询动态列表
     *
     * @param bbsMoment 动态
     * @return 动态集合
     */
    List<BbsMoment> selectBbsMomentList(BbsMoment bbsMoment);


    /**
     * 删除动态
     *
     * @param id 动态Id
     */
    void deleteMoment(Long id);


    /**
     * 查询用户动态统计
     *
     * @return 动态统计
     */
    BbsUserMomentCountVO getUserMomentCount(String userName);


    /**
     * 查询用户动态列表
     *
     * @param userName 用户名
     * @param content 动态内容
     * @return 动态列表
     */
    List<BbsMomentListVO> getUserMoments(String userName, String content);


    /**
     * 查询动态列表
     *
     * @param userName 用户名
     * @param content 动态内容
     * @return 动态列表
     */
    List<BbsMomentListVO> getMoments(String userName, String content);


    /**
     * 创建动态
     *
     * @param bo 动态
     */
    void userCreateMoment(CreateMomentBO bo);


    /**
     * 删除动态
     *
     * @param momentId 动态Id
     */
    void userDeleteMoment(Long momentId);


    /**
     * 点赞动态
     *
     * @param bo 动态
     */
    int likeMoment(LikeMomentBO bo);

}
