package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentLike;

/**
 * 动态点赞记录Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentLikeService extends IService<BbsMomentLike> {

	/**
	 * 查询用户点赞记录数量
	 *
	 * @param momentId 动态Id
	 * @param userName 用户名
	 * @return 点赞记录
	 */
	long getMomentLikeCount(Long momentId, String userName);


	/**
	 * 添加点赞记录
	 *
	 * @param momentId 动态Id
	 * @param userName 用户名
	 */
	void addMomentLike(Long momentId, String userName);


	/**
	 * 删除点赞记录
	 *
	 * @param momentId 动态Id
	 * @param userName 用户名
	 */
	void deleteMomentLike(Long momentId, String userName);

}
