package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.mauth.MobileAuth;
import com.tangguo.domain.bo.CodeLoginBO;
import com.tangguo.service.impl.BbsUserService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 动态用户管理控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/user")
public class BbsUserController {

	@Resource
	private BbsUserService bbsUserService;


	/**
	 * 企微用户Code登录
	 *
	 * @param bo 登录参数
	 * @return 登录结果
	 */
	@PostMapping("/code/login")
	public AjaxResult codeLogin(@RequestBody CodeLoginBO bo) {
		Map<String, Object> tokenMap = this.bbsUserService.codeLogin(bo);
		return AjaxResult.success(tokenMap);
	}


	/**
	 * 查询用户信息
	 *
	 * @return 用户信息
	 */
	@MobileAuth
	@GetMapping("/profile")
	public AjaxResult getUserProfile() {
		Map<String, Object> profileMap = this.bbsUserService.getUserProfile();
		return AjaxResult.success(profileMap);
	}

}
