package com.tangguo.framework.mauth;

import com.tangguo.common.mauth.MobileAuth;
import com.tangguo.common.mauth.MobileTokenHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.Objects;

/**
 * 移动端用户认证拦截器
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@Slf4j
@Component
public class MobileAuthInterceptor implements HandlerInterceptor {

	/**
	 * 请求被处理之前调用
	 */
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
		if (!(handler instanceof HandlerMethod)) {
			return true;
		}

		// 获取处理器方法上的标识注解
		Method method = ((HandlerMethod) handler).getMethod();
		MobileAuth mobileAuth = method.getAnnotation(MobileAuth.class);
		if (Objects.isNull(mobileAuth)) {
			return true;
		}

		String username = MobileTokenHelper.getUsername();
		log.info("=> 当前移动端请求用户：{}", username);
		return true;
	}

}
