package com.tangguo.common.mauth;

import lombok.Getter;

/**
 * 移动端用户身份认证失败异常类
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@Getter
public class Mobile401Exception extends RuntimeException {

	private static final long serialVersionUID = -4189845692674690824L;

	/**
	 * 状态码
	 */
	private final int code = 401;

	/**
	 * 异常消息
	 */
	private final String message;


	public Mobile401Exception(String message) {
		this.message = message;
	}


	public Mobile401Exception(String message, Throwable cause) {
		super(message, cause);
		this.message = message;
	}

}
