import request from '@/utils/request'

// 积分商城列表
export function listData(params) {
    return request({
        url: '/bbs/points/goods/list',
        method: 'get',
        params
    })
}

// 积分商城详情
export function detailData(id) {
    return request({
        url: `/bbs/points/goods/${id}`,
        method: 'get'
    })
}

// 新增积分商城
export function addData(data) {
    return request({
        url: '/bbs/points/goods',
        method: 'post',
        data
    })
}

// 修改积分商城
export function editData(data) {
    return request({
        url: '/bbs/points/goods',
        method: 'put',
        data
    })
}


// 删除积分商城
export function delData(id) {
    return request({
        url: `/bbs/points/goods/${id}`,
        method: 'delete'
    })
}