package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户积分对象 bbs_user_points
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_user_points")
@ApiModel(value = "BbsUserPoints", description = "用户积分实体")
public class BbsUserPoints extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 用户名 */
	@Excel(name = "用户名")
	@ApiModelProperty("用户名")
	private String userName;

	/** 累计积分 */
	@Excel(name = "累计积分")
	@ApiModelProperty("累计积分")
	private Integer accumulatedPoints;

	/** 当前积分 */
	@Excel(name = "当前积分")
	@ApiModelProperty("当前积分")
	private Integer currentPoints;

	/** 当前等级编码 */
	@Excel(name = "当前等级编码")
	@ApiModelProperty("当前等级编码")
	private String gradeCode;

	/** 当前等级名称 */
	@Excel(name = "当前等级名称")
	@ApiModelProperty("当前等级名称")
	private String gradeName;

	/** 等级升级时间 */
	@Excel(name = "等级升级时间")
	@ApiModelProperty("等级升级时间")
	private Date lastUpgradeTime;


	/**
	 * 用户姓名
	 */
	@Excel(name = "用户姓名")
	@TableField(exist = false)
	private String nikeName;

	/**
	 * 用户部门
	 */
	@Excel(name = "部门名称")
	@TableField(exist = false)
	private String deptName;

	/**
	 * 起始积分
	 */
	@TableField(exist = false)
	private Integer startPoints;

	/**
	 * 截至积分
	 */
	@TableField(exist = false)
	private Integer endPoints;

	/**
	 * 增加或扣减积分
	 */
	@TableField(exist = false)
	private Integer incrOrDecrPoints;

}
