package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentComment;
import com.tangguo.domain.BbsMomentVoteOption;
import com.tangguo.domain.vo.BbsCommentDetailVO;
import com.tangguo.domain.vo.BbsCommentVO;

import java.util.List;

/**
 * 动态评论记录Service接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface IBbsMomentCommentService extends IService<BbsMomentComment> {

    /**
     * 查询动态评论记录列表
     *
     * @param comment 动态评论记录
     * @return 动态评论记录集合
     */
    List<BbsMomentComment> selectBbsMomentCommentList(BbsMomentComment comment);


    /**
     * 查询动态评论记录详情
     *
     * @param commentId 动态评论记录Id
     * @return 动态评论记录详情
     */
    BbsMomentComment getBbsMomentComment(Long commentId);


    /**
     * 查询动态评论
     *
     * @param momentIds 动态Ids
     * @return 投票选项
     */
    List<BbsMomentComment> getComments(List<Long> momentIds);


    /**
     * 删除评论
     *
     * @param commentId 评论Id
     */
    void deleteComment(Long commentId);


    /**
     * 查询动态评论
     *
     * @param momentId 动态Id
     * @param userName 用户名
     * @return 评论
     */
    List<BbsCommentDetailVO> getMomentComments(Long momentId, String userName);

}
