package com.tangguo.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * 动态类型
 *
 * @author 谈笑
 * @createTime 2025-09-03 17:11:39 星期三
 */
@Getter
@AllArgsConstructor
public enum MomentType {

	TEXT("文本动态"), IMAGE("图片动态"), VIDEO("视频动态"), URL("链接动态");

	private final String desc;


	public static MomentType getMomentType(String type) {
		return Arrays.stream(MomentType.values())
			.filter(t -> t.name().equals(type)).findFirst().orElse(null);
	}

}
