package com.tangguo.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * 动态点赞状态枚举
 *
 * @author 谈笑
 * @createTime 2025-09-04 15:30:52 星期四
 */
@Getter
@AllArgsConstructor
public enum LikeStatus {

	LIKE(1, "点赞"), UNLIKE(0, "取消点赞");

	private final int status;

	private final String desc;


	public static LikeStatus getLikeStatus(int status) {
		return Arrays.stream(LikeStatus.values())
			.filter(s -> s.getStatus() == status).findFirst().orElse(null);
	}

}
