import request from '@/utils/request'

// 积分管理列表
export function listData(params) {
    return request({
        url: '/bbs/points/user/points/list',
        method: 'get',
        params
    })
}

// 积分明细
export function detailData(params) {
    return request({
        url: `/bbs/points/user/points/details`,
        method: 'get',
        params
    })
}

// 导出用户
export function exportUser(data){
    return request({
        url:'/bbs/points/user/points/export',
        method:'post',
        data
    })
}

// 增加积分
export function addData(data) {
    return request({
        url: '/bbs/points/user/points/incr',
        method: 'put',
        data
    })
}

// 扣减积分
export function editData(data) {
    return request({
        url: '/bbs/points/user/points/decr',
        method: 'put',
        data
    })
}

