package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.mauth.MobileAuth;
import com.tangguo.common.utils.PageUtils;
import com.tangguo.common.utils.ValidateOperations;
import com.tangguo.domain.bo.CreateTopicBO;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.domain.vo.BbsTopicListVO;
import com.tangguo.service.IBbsTopicService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 移动端话题控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 16:19:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/topic")
public class MBbsTopicController {

	@Resource
	private IBbsTopicService topicService;


	/**
	 * 查询选择话题
	 *
	 * @param name 话题名称
	 * @return 话题
	 */
	@MobileAuth
	@GetMapping("/select")
	public TableDataInfo getSelectTopics(String name) {
		PageUtils.startPage();
		List<BbsTopicListVO> topics = this.topicService.getSelectTopics(name);
		return TableDataInfo.getDataTable(topics);
	}


	/**
	 * 创建话题
	 *
	 * @param bo 话题
	 * @return 创建结果
	 */
	@MobileAuth
	@PostMapping("/create")
	public AjaxResult createTopic(@RequestBody CreateTopicBO bo) {
		ValidateOperations.generalValidate(bo);
		BbsTopicListVO topic = this.topicService.createTopic(bo);
		return AjaxResult.success(topic);
	}


	/**
	 * 查询热搜话题
	 *
	 * @return 话题
	 */
	@MobileAuth
	@GetMapping("/ranking")
	public AjaxResult getRankingTopic() {
		List<BbsTopicListVO> topics = this.topicService.getRankingTopic();
		return AjaxResult.success(topics);
	}


	/**
	 * 查询话题详情
	 *
	 * @param topicId 话题Id
	 * @return 话题明细
	 */
	@MobileAuth
	@GetMapping("/details")
	public TableDataInfo getTopicDetails(@RequestParam Long topicId) {
		PageUtils.startPage();
		List<BbsMomentListVO> details = this.topicService.getTopicDetails(topicId);
		return TableDataInfo.getDataTable(details);
	}

}
