package com.tangguo.controller.pc;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.domain.BbsMomentComment;
import com.tangguo.service.IBbsMomentCommentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 动态评论记录Controller
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Api(tags="动态评论记录管理")
@RestController
@RequestMapping("/bbs/moment/comment")
public class BbsMomentCommentController extends BaseController {

    @Resource
    private IBbsMomentCommentService bbsMomentCommentService;


    /**
     * 查询动态评论记录列表
     */
    @ApiOperation("查询动态评论记录列表")
    @PreAuthorize("@ss.hasPermi('moment:comment:list')")
    @GetMapping("/list")
    public TableDataInfo list(BbsMomentComment comment) {
        startPage();
        List<BbsMomentComment> list = bbsMomentCommentService.selectBbsMomentCommentList(comment);
        return getDataTable(list);
    }


    /**
     * 获取动态评论记录详细信息
     */
    @ApiOperation("获取动态评论记录详细信息")
    @PreAuthorize("@ss.hasPermi('moment:comment:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        BbsMomentComment comment = this.bbsMomentCommentService.getBbsMomentComment(id);
        return success(comment);
    }


    /**
     * 删除动态评论记录
     */
    @ApiOperation("删除动态评论记录")
    @PreAuthorize("@ss.hasPermi('moment:comment:remove')")
    @Log(title = "动态评论记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
    public AjaxResult remove(@PathVariable Long id) {
        this.bbsMomentCommentService.deleteComment(id);
        return AjaxResult.success();
    }

}
