import config from '@/config/index.config.js';
import {getToken,setRedirectPath} from '@/utils/auth';
import errorCode from '@/utils/errorCode';
import {toast,showConfirm,tansParams} from '@/utils/common'
import store from '@/store';
let timeout = 30000
const baseUrl = config.requestUrl + '/bbs/mobile/'

const request = config => {
	// 是否需要设置 token
	const isToken = (config.headers || {}).isToken === false
	// 是否需要加密
	// const isEncrypt = (config.headers || {}).isEncrypt === 'true';

	config.header = config.headers || {}
	if (getToken() && !isToken) {
		config.header['Authorization'] = 'Bearer ' + getToken()
	}
	// get请求映射params参数
	if (config.params) {
		let url = config.url + '?' + tansParams(config.params)
		url = url.slice(0, -1)
		config.url = url
	}
	return new Promise((resolve, reject) => {
		uni.request({
			method: config.method || 'get',
			timeout: config.timeout || timeout,
			url: config.baseUrl || baseUrl + config.url,
			data: config.data,
			header: config.header,
			dataType: 'json',
		}).then(response => {
			let {
				error,
				data
			} = response
			if (error) {
				toast('后端接口连接异常')
				reject('后端接口连接异常')
				return
			}
			const code = data.code || 200
			const msg = errorCode[code] || data.msg || errorCode['default']
			if (code === 401) {
			
				showConfirm('登录状态已过期，您可以继续留在该页面，或者重新登录?').then(res => {
					if (res.confirm) {
						store.dispatch('LogOut').then(res => {
							uni.reLaunch({
								url: '/pages/login/login'
							})
						})
					}
				})
				reject('无效的会话，或者会话已过期，请重新登录。')
			} else if (code === 500) {
				toast(msg)
				reject('500')
			} else if (code !== 200) {
				toast(msg)
				reject(code)
			}
			resolve(data)
		}).catch(error => {
			console.log(error);
			let {
				errMsg: message
			} = error
			if (message === 'Network Error' || message === 'request:fail') {
				message = '后端接口连接异常'
			} else if (message.includes('timeout')) {
				message = '系统接口请求超时'
			} else if (message.includes('Request failed with status code')) {
				message = '系统接口' + message.substr(message.length - 3) + '异常'
			}
			toast(message)
			reject(error)
		})
	})
}

export default request