package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 积分商品对象 bbs_points_goods
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_points_goods")
@ApiModel(value = "BbsPointsGoods", description = "积分商品实体")
public class BbsPointsGoods extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 商品名称 */
	@Excel(name = "商品名称")
	@ApiModelProperty("商品名称")
	private String name;

	/** 商品编码 */
	@Excel(name = "商品编码")
	@ApiModelProperty("商品编码")
	private String code;

	/** 商品图片地址 */
	@Excel(name = "商品图片地址")
	@ApiModelProperty("商品图片地址")
	private String imgsUrl;

	/** 销售价格 */
	@Excel(name = "销售价格")
	@ApiModelProperty("销售价格")
	private BigDecimal salesPrice;

	/** 兑换积分 */
	@Excel(name = "兑换积分")
	@ApiModelProperty("兑换积分")
	private Integer exchangePoints;

	/** 库存数量 */
	@Excel(name = "库存数量")
	@ApiModelProperty("库存数量")
	private Integer stockNum;

	/** 已兑数量 */
	@Excel(name = "已兑数量")
	@ApiModelProperty("已兑数量")
	private Integer salesNum;

	/** 上架状态：0 下架、1 上架 */
	@Excel(name = "上架状态：0 下架、1 上架")
	@ApiModelProperty("上架状态：0 下架、1 上架")
	private Integer showStatus;

}
