package com.tangguo.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsMomentVoteOption;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.mapper.BbsMomentVoteOptionMapper;
import com.tangguo.service.IBbsMomentVoteOptionService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 动态投票选项Service业务层处理
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Service
public class BbsMomentVoteOptionServiceImpl extends ServiceImpl<BbsMomentVoteOptionMapper, BbsMomentVoteOption> implements IBbsMomentVoteOptionService {

    @Resource
    private BbsMomentVoteOptionMapper bbsMomentVoteOptionMapper;


    /**
     * 查询动态投票选项
     *
     * @param momentId 动态Id
     * @return 投票选项
     */
    @Override
    public List<BbsMomentVoteOption> getVoteOptions(Long momentId) {
        return this.list(
            Wrappers.lambdaQuery(BbsMomentVoteOption.class).eq(BbsMomentVoteOption::getMomentId, momentId)
        );
    }


    /**
     * 添加动态投票选项
     *
     * @param momentId    动态Id
     * @param voteOptions 投票选项
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addVoteOptions(Long momentId, List<CreateMomentBO.VoteOption> voteOptions) {
        if (CollUtil.isNotEmpty(voteOptions)) {
            List<BbsMomentVoteOption> newVoteOptions = new ArrayList<>(voteOptions.size());
            for (CreateMomentBO.VoteOption voteOption : voteOptions) {
                BbsMomentVoteOption newVoteOption = new BbsMomentVoteOption();
                newVoteOption.setMomentId(momentId);
                newVoteOption.setType(voteOption.getType());
                newVoteOption.setName(voteOption.getName());
                newVoteOption.setCode(voteOption.getCode());
                newVoteOption.setImageUrl(voteOption.getImageUrl());
                newVoteOption.setSort(voteOption.getSort());
                newVoteOptions.add(newVoteOption);
            }
            this.saveBatch(newVoteOptions);
        }
    }


    /**
     * 删除动态投票选项
     *
     * @param momentId 动态Id
     */
    @Override
    public void deleteVoteOptions(Long momentId) {
        this.remove(
            Wrappers.lambdaQuery(BbsMomentVoteOption.class).eq(BbsMomentVoteOption::getMomentId, momentId)
        );
    }

}
