package com.tangguo.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsMomentAttachment;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.mapper.BbsMomentAttachmentMapper;
import com.tangguo.service.IBbsMomentAttachmentService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 动态附件Service业务层处理
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Service
public class BbsMomentAttachmentServiceImpl extends ServiceImpl<BbsMomentAttachmentMapper, BbsMomentAttachment> implements IBbsMomentAttachmentService {

    @Resource
    private BbsMomentAttachmentMapper bbsMomentAttachmentMapper;


    /**
     * 查询动态附件
     *
     * @param momentId 动态Id
     * @return 附件
     */
    @Override
    public List<BbsMomentAttachment> getAttachments(Long momentId) {
        return this.list(
            Wrappers.lambdaQuery(BbsMomentAttachment.class).eq(BbsMomentAttachment::getMomentId, momentId)
        );
    }


    /**
     * 添加动态附件
     *
     * @param userName    用户名
     * @param momentId    动态Id
     * @param attachments 动态附件
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addAttachments(String userName, Long momentId, List<CreateMomentBO.Attachment> attachments) {
        if (CollUtil.isNotEmpty(attachments)) {
            List<BbsMomentAttachment> newAttachments = new ArrayList<>(attachments.size());
            for (CreateMomentBO.Attachment attachment : attachments) {
                BbsMomentAttachment newAttachment = new BbsMomentAttachment();
                newAttachment.setMomentId(momentId);
                newAttachment.setUserName(userName);
                newAttachment.setName(attachment.getName());
                newAttachment.setType(attachment.getType());
                newAttachment.setUrl(attachment.getUrl());
                newAttachment.setFileExt(attachment.getFileExt());
                newAttachments.add(newAttachment);
            }
            this.saveBatch(newAttachments);
        }
    }


    /**
     * 删除动态附件
     *
     * @param momentId 动态Id
     */
    @Override
    public void deleteAttachments(Long momentId) {
        this.remove(
            Wrappers.lambdaQuery(BbsMomentAttachment.class).eq(BbsMomentAttachment::getMomentId, momentId)
        );
    }

}
