package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentVoteOption;
import com.tangguo.domain.bo.CreateMomentBO;

import java.util.List;

/**
 * 动态投票选项Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentVoteOptionService extends IService<BbsMomentVoteOption> {

	/**
	 * 查询动态投票选项
	 *
	 * @param momentId 动态Id
	 * @return 投票选项
	 */
	List<BbsMomentVoteOption> getVoteOptions(Long momentId);


	/**
	 * 添加动态投票选项
	 *
	 * @param momentId 动态Id
	 * @param voteOptions 投票选项
	 */
	void addVoteOptions(Long momentId, List<CreateMomentBO.VoteOption> voteOptions);


	/**
	 * 删除动态投票选项
	 *
	 * @param momentId 动态Id
	 */
	void deleteVoteOptions(Long momentId);

}
