package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.mauth.MobileAuth;
import com.tangguo.common.mauth.MobileTokenHelper;
import com.tangguo.common.utils.PageUtils;
import com.tangguo.domain.bo.CodeLoginBO;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.domain.vo.BbsUserMomentCountVO;
import com.tangguo.service.IBbsMomentService;
import com.tangguo.service.impl.BbsUserService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 移动端用户控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/user")
public class MBbsUserController {

	@Resource
	private BbsUserService bbsUserService;

	@Resource
	private IBbsMomentService momentService;


	/**
	 * 企微用户Code登录
	 *
	 * @param bo 登录参数
	 * @return 登录结果
	 */
	@PostMapping("/code/login")
	public AjaxResult codeLogin(@RequestBody CodeLoginBO bo) {
		Map<String, Object> tokenMap = this.bbsUserService.codeLogin(bo);
		return AjaxResult.success(tokenMap);
	}


	/**
	 * 查询用户信息
	 *
	 * @return 用户信息
	 */
	@MobileAuth
	@GetMapping("/profile")
	public AjaxResult getUserProfile() {
		Map<String, Object> profileMap = this.bbsUserService.getUserProfile();
		return AjaxResult.success(profileMap);
	}


	/**
	 * 查询用户动态统计
	 *
	 * @return 动态统计
	 */
	@MobileAuth
	@GetMapping("/moment/count")
	public AjaxResult getUserMomentCount() {
		String username = MobileTokenHelper.getUsername();
		BbsUserMomentCountVO momentCount = this.momentService.getUserMomentCount(username);
		return AjaxResult.success(momentCount);
	}


	/**
	 * 查询用户动态列表
	 *
	 * @return 动态
	 */
	@MobileAuth
	@GetMapping("/moments")
	public AjaxResult getUserMoments(String content) {
		String username = MobileTokenHelper.getUsername();
		PageUtils.clearPage();
		List<BbsMomentListVO> moments = this.momentService.getUserMoments(username, content);
		return AjaxResult.success(moments);
	}

}
