package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.mauth.MobileAuth;
import com.tangguo.common.mauth.MobileTokenHelper;
import com.tangguo.common.utils.PageUtils;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.service.IBbsMomentService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 移动端动态控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 16:19:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/moment")
public class MBbsMomentController {

	@Resource
	private IBbsMomentService momentService;


	/**
	 * 查询动态列表
	 *
	 * @return 动态
	 */
	@MobileAuth
	@GetMapping("/moments")
	public AjaxResult getUserMoments(String content) {
		String username = MobileTokenHelper.getUsername();
		PageUtils.clearPage();
		List<BbsMomentListVO> moments = this.momentService.getMoments(username, content);
		return AjaxResult.success(moments);
	}


	/**
	 * 创建动态
	 *
	 * @param bo 动态
	 * @return 创建结果
	 */
	@MobileAuth
	@PostMapping("/create")
	public AjaxResult createMoment(@RequestBody CreateMomentBO bo) {
		this.momentService.userCreateMoment(bo);
		return AjaxResult.success();
	}


	/**
	 * 删除动态
	 *
	 * @param momentId 动态Id
	 * @return 删除结果
	 */
	@MobileAuth
	@DeleteMapping("/delete/{momentId}")
	public AjaxResult createMoment(@PathVariable Long momentId) {
		this.momentService.userDeleteMoment(momentId);
		return AjaxResult.success();
	}

}
