package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsPointsSetting;

import java.util.List;
import java.util.Map;

/**
 * 积分规则配置Service接口
 *
 * @author ruoyi
 * @date 2025-08-29
 */
public interface IBbsPointsSettingService extends IService<BbsPointsSetting> {

    /**
     * 查询积分规则配置列表
     *
     * @param bbsPointsSetting 积分规则配置
     * @return 积分规则配置集合
     */
    List<BbsPointsSetting> selectBbsPointsSettingList(BbsPointsSetting bbsPointsSetting);


    /**
     * 查询积分规则配置明细
     *
     * @return 配置明细
     */
    Map<String, List<BbsPointsSetting>> getSettingDetails();


    /**
     * 添加积分配置
     *
     * @param setting 积分配置
     */
    void addSetting(BbsPointsSetting setting);


    /**
     * 修改积分配置
     *
     * @param setting 积分配置
     */
    void editSetting(BbsPointsSetting setting);


    /**
     * 删除积分配置
     *
     * @param settingId 配置Id
     */
    void deleteSetting(Long settingId);


    /**
     * 修改配置状态
     *
     * @param setting 积分配置
     */
    void setSettingStatus(BbsPointsSetting setting);

}
