package com.tangguo.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.utils.poi.ExcelUtil;
import com.tangguo.domain.BbsPointsGoods;
import com.tangguo.domain.BbsUserPointsExchange;
import com.tangguo.domain.vo.QwmhSysUserVO;
import com.tangguo.mapper.BbsUserPointsExchangeMapper;
import com.tangguo.service.IBbsPointsGoodsService;
import com.tangguo.service.IBbsUserPointsExchangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 用户积分兑换Controller
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Api(tags = "用户积分兑换管理")
@RestController
@RequestMapping("/bbs/points/exchange")
public class BbsUserPointsExchangeController extends BaseController {

	@Resource
	private BbsUserPointsExchangeMapper userPointsExchangeMapper;

	@Resource
	private IBbsUserPointsExchangeService bbsUserPointsExchangeService;

	@Resource
	private IBbsPointsGoodsService pointsGoodsService;


	/**
	 * 查询兑换人
	 */
	@ApiOperation("查询兑换人")
	@PreAuthorize("@ss.hasPermi('points:points:list')")
	@GetMapping("/select/users")
	public AjaxResult selectUsers(String keyword) {
		List<QwmhSysUserVO> users = this.userPointsExchangeMapper.selectPointsUsers(keyword);
		return AjaxResult.success(users);
	}


	/**
	 * 查询兑换商品
	 */
	@ApiOperation("查询兑换人")
	@PreAuthorize("@ss.hasPermi('points:points:list')")
	@GetMapping("/select/goods")
	public AjaxResult selectGoods(String keyword) {
		LambdaQueryWrapper<BbsPointsGoods> wrapper = new LambdaQueryWrapper<>();
		wrapper.like(StrUtil.isNotBlank(keyword), BbsPointsGoods::getName, keyword);
		wrapper.or();
		wrapper.like(StrUtil.isNotBlank(keyword), BbsPointsGoods::getCode, keyword);
		wrapper.orderByDesc(BbsPointsGoods::getCreateTime);
		List<BbsPointsGoods> goods = this.pointsGoodsService.list(wrapper);
		return AjaxResult.success(goods);
	}


	/**
	 * 查询用户积分兑换列表
	 */
	@ApiOperation("查询用户积分兑换列表")
	@PreAuthorize("@ss.hasPermi('points:points:list')")
	@GetMapping("/list")
	public TableDataInfo list(BbsUserPointsExchange exchange) {
		startPage();
		List<BbsUserPointsExchange> list = bbsUserPointsExchangeService.selectBbsUserPointsExchangeList(exchange);
		return getDataTable(list);
	}


	/**
	 * 导出用户积分列表
	 */
	@ApiOperation("导出用户积分列表")
	@PreAuthorize("@ss.hasPermi('points:points:export')")
	@Log(title = "用户积分", businessType = BusinessType.EXPORT)
	@PostMapping("/export")
	public void export(HttpServletResponse response, BbsUserPointsExchange exchange) {
		List<BbsUserPointsExchange> list = bbsUserPointsExchangeService.selectBbsUserPointsExchangeList(exchange);
		ExcelUtil<BbsUserPointsExchange> util = new ExcelUtil<>(BbsUserPointsExchange.class);
		util.exportExcel(response, list, "用户积分数据");
	}



	/**
	 * 用户积分兑换
	 */
	@ApiOperation("用户积分兑换")
	@PreAuthorize("@ss.hasPermi('points:points:exchange')")
	@Log(title = "用户积分兑换", businessType = BusinessType.INSERT)
	@PostMapping("/exchange")
	public synchronized AjaxResult exchange(@RequestBody BbsUserPointsExchange exchange) {
		synchronized (exchange.getUserName().intern()) {
			this.bbsUserPointsExchangeService.addUserPointsExchange(exchange);
		}
		return AjaxResult.success();
	}

}
