package com.tangguo;

import com.tangguo.common.constant.ActiveMQConstant;
import com.tangguo.domain.dto.PointsDetail;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jms.core.JmsTemplate;

import javax.annotation.Resource;

/**
 *
 *
 * @author 谈笑
 * @createTime 2025-09-01 16:18:29 星期一
 */
@SpringBootTest
public class ApplicationTest {

	@Resource
	private JmsTemplate jmsTemplate;


	@Test
	public void test() {
		PointsDetail detail = new PointsDetail();
		detail.setUserName("TanXiao");
		detail.setDetailPoints(10);
		detail.setDetailName("外部系统");
		detail.setDescription("外部系统");
		this.jmsTemplate.convertAndSend(ActiveMQConstant.Points.INCR_USER_POINTS_QUEUE, detail);
		this.jmsTemplate.convertAndSend(ActiveMQConstant.Points.DECR_USER_POINTS_QUEUE, detail);
	}

}
