package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 用户等级对象 bbs_grade
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_grade")
@ApiModel(value = "BbsGrade", description = "用户等级实体")
public class BbsGrade extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 等级名称 */
	@Excel(name = "等级名称")
	@ApiModelProperty("等级名称")
	private String name;

	/** 等级编码 */
	@Excel(name = "等级编码")
	@ApiModelProperty("等级编码")
	private String code;

	/** 最小积分 */
	@Excel(name = "最小积分")
	@ApiModelProperty("最小积分")
	private Integer minPoints;

	/** 最大积分 */
	@Excel(name = "最大积分")
	@ApiModelProperty("最大积分")
	private Integer maxPoints;

	/** 排序值（升序） */
	@Excel(name = "排序值", readConverterExp = "升=序")
	@ApiModelProperty("排序值（升序）")
	private Integer sort;

}
