package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.utils.poi.ExcelUtil;
import com.tangguo.domain.BbsPointsSetting;
import com.tangguo.service.IBbsPointsSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 积分规则配置Controller
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Api(tags = "积分规则配置管理")
@RestController
@RequestMapping("/points/points")
public class BbsPointsSettingController extends BaseController {

	@Resource
	private IBbsPointsSettingService bbsPointsSettingService;


	/**
	 * 查询积分规则配置列表
	 */
	@ApiOperation("查询积分规则配置列表")
	@PreAuthorize("@ss.hasPermi('points:points:list')")
	@GetMapping("/list")
	public TableDataInfo list(BbsPointsSetting bbsPointsSetting) {
		startPage();
		List<BbsPointsSetting> list = bbsPointsSettingService.selectBbsPointsSettingList(bbsPointsSetting);
		return getDataTable(list);
	}


	/**
	 * 导出积分规则配置列表
	 */
	@ApiOperation("导出积分规则配置列表")
	@PreAuthorize("@ss.hasPermi('points:points:export')")
	@Log(title = "积分规则配置", businessType = BusinessType.EXPORT)
	@PostMapping("/export")
	public void export(HttpServletResponse response, BbsPointsSetting bbsPointsSetting) {
		List<BbsPointsSetting> list = bbsPointsSettingService.selectBbsPointsSettingList(bbsPointsSetting);
		ExcelUtil<BbsPointsSetting> util = new ExcelUtil<BbsPointsSetting>(BbsPointsSetting.class);
		util.exportExcel(response, list, "积分规则配置数据");
	}


	/**
	 * 获取积分规则配置详细信息
	 */
	@ApiOperation("获取积分规则配置详细信息")
	@PreAuthorize("@ss.hasPermi('points:points:query')")
	@GetMapping(value = "/{id}")
	public AjaxResult getInfo(@PathVariable("id") Long id) {
		return success(bbsPointsSettingService.getById(id));
	}


	/**
	 * 新增积分规则配置
	 */
	@ApiOperation("新增积分规则配置")
	@PreAuthorize("@ss.hasPermi('points:points:add')")
	@Log(title = "积分规则配置", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@RequestBody BbsPointsSetting bbsPointsSetting) {
		return toAjax(bbsPointsSettingService.save(bbsPointsSetting));
	}


	/**
	 * 修改积分规则配置
	 */
	@ApiOperation("修改积分规则配置")
	@PreAuthorize("@ss.hasPermi('points:points:edit')")
	@Log(title = "积分规则配置", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@RequestBody BbsPointsSetting bbsPointsSetting) {
		return toAjax(bbsPointsSettingService.updateById(bbsPointsSetting));
	}


	/**
	 * 删除积分规则配置
	 */
	@ApiOperation("删除积分规则配置")
	@PreAuthorize("@ss.hasPermi('points:points:remove')")
	@Log(title = "积分规则配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
	public AjaxResult remove(@PathVariable Long[] ids) {
		return toAjax(bbsPointsSettingService.removeByIds(Arrays.asList(ids)));
	}

}
