package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsUserPoints;
import com.tangguo.mapper.BbsUserPointsMapper;
import com.tangguo.service.IBbsUserPointsService;
import org.springframework.stereotype.Service;
import com.tangguo.common.utils.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 用户积分Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Service
public class BbsUserPointsServiceImpl extends ServiceImpl<BbsUserPointsMapper, BbsUserPoints> implements IBbsUserPointsService {

    @Resource
    private BbsUserPointsMapper bbsUserPointsMapper;

    /**
     * 查询用户积分列表
     *
     * @param bbsUserPoints 用户积分
     * @return 用户积分
     */
    @Override
    public List<BbsUserPoints> selectBbsUserPointsList(BbsUserPoints bbsUserPoints) {
	    return bbsUserPointsMapper.selectList(buildQueryWrapper(bbsUserPoints));
    }


    private LambdaQueryWrapper<BbsUserPoints> buildQueryWrapper(BbsUserPoints query) {
        Map<String, Object> params = query.getParams();
        LambdaQueryWrapper<BbsUserPoints> lqw = Wrappers.lambdaQuery();
        lqw.orderByDesc(BbsUserPoints::getCreateTime);
        lqw.like(StringUtils.isNotBlank(query.getNikeName()), BbsUserPoints::getNikeName, query.getNikeName());
        lqw.like(StringUtils.isNotBlank(query.getUserName()), BbsUserPoints::getUserName, query.getUserName());
        lqw.eq(query.getAccumulatedPoints() != null, BbsUserPoints::getAccumulatedPoints, query.getAccumulatedPoints());
        lqw.eq(query.getCurrentPoints() != null, BbsUserPoints::getCurrentPoints, query.getCurrentPoints());
        return lqw;
    }

}
