package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsUserPointsDetail;
import com.tangguo.mapper.BbsUserPointsDetailMapper;
import com.tangguo.service.IBbsUserPointsDetailService;
import org.springframework.stereotype.Service;
import com.tangguo.common.utils.StringUtils;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * 用户积分明细Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Service
public class BbsUserPointsDetailServiceImpl extends ServiceImpl<BbsUserPointsDetailMapper, BbsUserPointsDetail> implements IBbsUserPointsDetailService {

    @Resource
    private BbsUserPointsDetailMapper bbsUserPointsDetailMapper;

    /**
     * 查询用户积分明细列表
     *
     * @param bbsUserPointsDetail 用户积分明细
     * @return 用户积分明细
     */
    @Override
    public List<BbsUserPointsDetail> selectBbsUserPointsDetailList(BbsUserPointsDetail bbsUserPointsDetail) {
	    return bbsUserPointsDetailMapper.selectList(buildQueryWrapper(bbsUserPointsDetail));
    }


    private LambdaQueryWrapper<BbsUserPointsDetail> buildQueryWrapper(BbsUserPointsDetail query) {
        Map<String, Object> params = query.getParams();
        LambdaQueryWrapper<BbsUserPointsDetail> lqw = Wrappers.lambdaQuery();
        lqw.orderByDesc(BbsUserPointsDetail::getCreateTime);
        lqw.like(StringUtils.isNotBlank(query.getUserName()), BbsUserPointsDetail::getUserName, query.getUserName());
        lqw.like(StringUtils.isNotBlank(query.getDetailName()), BbsUserPointsDetail::getDetailName, query.getDetailName());
        lqw.eq(StringUtils.isNotBlank(query.getDetailCode()), BbsUserPointsDetail::getDetailCode, query.getDetailCode());
        lqw.eq(query.getDetailPoints() != null, BbsUserPointsDetail::getDetailPoints, query.getDetailPoints());
        lqw.eq(query.getBeforePoints() != null, BbsUserPointsDetail::getBeforePoints, query.getBeforePoints());
        lqw.eq(query.getAfterPoints() != null, BbsUserPointsDetail::getAfterPoints, query.getAfterPoints());
        lqw.eq(StringUtils.isNotBlank(query.getDescription()), BbsUserPointsDetail::getDescription, query.getDescription());
        return lqw;
    }

}
