package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsPointsSetting;
import com.tangguo.mapper.BbsPointsSettingMapper;
import com.tangguo.service.IBbsPointsSettingService;
import org.springframework.stereotype.Service;
import com.tangguo.common.utils.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 积分规则配置Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Service
public class BbsPointsSettingServiceImpl extends ServiceImpl<BbsPointsSettingMapper, BbsPointsSetting> implements IBbsPointsSettingService {

    @Resource
    private BbsPointsSettingMapper bbsPointsSettingMapper;

    /**
     * 查询积分规则配置列表
     *
     * @param bbsPointsSetting 积分规则配置
     * @return 积分规则配置
     */
    @Override
    public List<BbsPointsSetting> selectBbsPointsSettingList(BbsPointsSetting bbsPointsSetting) {
	    return bbsPointsSettingMapper.selectList(buildQueryWrapper(bbsPointsSetting));
    }


    private LambdaQueryWrapper<BbsPointsSetting> buildQueryWrapper(BbsPointsSetting query) {
        Map<String, Object> params = query.getParams();
        LambdaQueryWrapper<BbsPointsSetting> lqw = Wrappers.lambdaQuery();
        lqw.orderByDesc(BbsPointsSetting::getCreateTime);
        lqw.eq(StringUtils.isNotBlank(query.getType()), BbsPointsSetting::getType, query.getType());
        lqw.like(StringUtils.isNotBlank(query.getAgentName()), BbsPointsSetting::getAgentName, query.getAgentName());
        lqw.eq(StringUtils.isNotBlank(query.getAgentId()), BbsPointsSetting::getAgentId, query.getAgentId());
        lqw.like(StringUtils.isNotBlank(query.getOperateName()), BbsPointsSetting::getOperateName, query.getOperateName());
        lqw.eq(StringUtils.isNotBlank(query.getOperateCode()), BbsPointsSetting::getOperateCode, query.getOperateCode());
        lqw.eq(query.getOperatePoints() != null, BbsPointsSetting::getOperatePoints, query.getOperatePoints());
        lqw.eq(query.getLimitCount() != null, BbsPointsSetting::getLimitCount, query.getLimitCount());
        lqw.eq(query.getEnableStatus() != null, BbsPointsSetting::getEnableStatus, query.getEnableStatus());
        return lqw;
    }

}
