package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsUserPointsExchange;
import com.tangguo.mapper.BbsUserPointsExchangeMapper;
import com.tangguo.service.IBbsUserPointsExchangeService;
import org.springframework.stereotype.Service;
import com.tangguo.common.utils.StringUtils;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * 用户积分兑换Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Service
public class BbsUserPointsExchangeServiceImpl extends ServiceImpl<BbsUserPointsExchangeMapper, BbsUserPointsExchange> implements IBbsUserPointsExchangeService {

    @Resource
    private BbsUserPointsExchangeMapper bbsUserPointsExchangeMapper;

    /**
     * 查询用户积分兑换列表
     *
     * @param bbsUserPointsExchange 用户积分兑换
     * @return 用户积分兑换
     */
    @Override
    public List<BbsUserPointsExchange> selectBbsUserPointsExchangeList(BbsUserPointsExchange bbsUserPointsExchange) {
	    return bbsUserPointsExchangeMapper.selectList(buildQueryWrapper(bbsUserPointsExchange));
    }


    private LambdaQueryWrapper<BbsUserPointsExchange> buildQueryWrapper(BbsUserPointsExchange query) {
        Map<String, Object> params = query.getParams();
        LambdaQueryWrapper<BbsUserPointsExchange> lqw = Wrappers.lambdaQuery();
        lqw.orderByDesc(BbsUserPointsExchange::getCreateTime);
        lqw.like(StringUtils.isNotBlank(query.getNikeName()), BbsUserPointsExchange::getNikeName, query.getNikeName());
        lqw.like(StringUtils.isNotBlank(query.getUserName()), BbsUserPointsExchange::getUserName, query.getUserName());
        lqw.like(StringUtils.isNotBlank(query.getUserGradeName()), BbsUserPointsExchange::getUserGradeName, query.getUserGradeName());
        lqw.like(StringUtils.isNotBlank(query.getGoodsName()), BbsUserPointsExchange::getGoodsName, query.getGoodsName());
        lqw.eq(StringUtils.isNotBlank(query.getGoodsCode()), BbsUserPointsExchange::getGoodsCode, query.getGoodsCode());
        lqw.eq(query.getGoodsExchangePoints() != null, BbsUserPointsExchange::getGoodsExchangePoints, query.getGoodsExchangePoints());
        lqw.eq(query.getUserRemainingPoints() != null, BbsUserPointsExchange::getUserRemainingPoints, query.getUserRemainingPoints());
        return lqw;
    }

}
