package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.utils.poi.ExcelUtil;
import com.tangguo.domain.BbsUserPointsExchange;
import com.tangguo.service.IBbsUserPointsExchangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 用户积分兑换Controller
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Api(tags = "用户积分兑换管理")
@RestController
@RequestMapping("/points/points")
public class BbsUserPointsExchangeController extends BaseController {

	@Resource
	private IBbsUserPointsExchangeService bbsUserPointsExchangeService;


	/**
	 * 查询用户积分兑换列表
	 */
	@ApiOperation("查询用户积分兑换列表")
	@PreAuthorize("@ss.hasPermi('points:points:list')")
	@GetMapping("/list")
	public TableDataInfo list(BbsUserPointsExchange bbsUserPointsExchange) {
		startPage();
		List<BbsUserPointsExchange> list = bbsUserPointsExchangeService.selectBbsUserPointsExchangeList(bbsUserPointsExchange);
		return getDataTable(list);
	}


	/**
	 * 导出用户积分兑换列表
	 */
	@ApiOperation("导出用户积分兑换列表")
	@PreAuthorize("@ss.hasPermi('points:points:export')")
	@Log(title = "用户积分兑换", businessType = BusinessType.EXPORT)
	@PostMapping("/export")
	public void export(HttpServletResponse response, BbsUserPointsExchange bbsUserPointsExchange) {
		List<BbsUserPointsExchange> list = bbsUserPointsExchangeService.selectBbsUserPointsExchangeList(bbsUserPointsExchange);
		ExcelUtil<BbsUserPointsExchange> util = new ExcelUtil<BbsUserPointsExchange>(BbsUserPointsExchange.class);
		util.exportExcel(response, list, "用户积分兑换数据");
	}


	/**
	 * 获取用户积分兑换详细信息
	 */
	@ApiOperation("获取用户积分兑换详细信息")
	@PreAuthorize("@ss.hasPermi('points:points:query')")
	@GetMapping(value = "/{id}")
	public AjaxResult getInfo(@PathVariable("id") Long id) {
		return success(bbsUserPointsExchangeService.getById(id));
	}


	/**
	 * 新增用户积分兑换
	 */
	@ApiOperation("新增用户积分兑换")
	@PreAuthorize("@ss.hasPermi('points:points:add')")
	@Log(title = "用户积分兑换", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@RequestBody BbsUserPointsExchange bbsUserPointsExchange) {
		return toAjax(bbsUserPointsExchangeService.save(bbsUserPointsExchange));
	}


	/**
	 * 修改用户积分兑换
	 */
	@ApiOperation("修改用户积分兑换")
	@PreAuthorize("@ss.hasPermi('points:points:edit')")
	@Log(title = "用户积分兑换", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@RequestBody BbsUserPointsExchange bbsUserPointsExchange) {
		return toAjax(bbsUserPointsExchangeService.updateById(bbsUserPointsExchange));
	}


	/**
	 * 删除用户积分兑换
	 */
	@ApiOperation("删除用户积分兑换")
	@PreAuthorize("@ss.hasPermi('points:points:remove')")
	@Log(title = "用户积分兑换", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
	public AjaxResult remove(@PathVariable Long[] ids) {
		return toAjax(bbsUserPointsExchangeService.removeByIds(Arrays.asList(ids)));
	}

}
