package com.tangguo;

import com.tangguo.common.constant.ActiveMQConstant;
import com.tangguo.common.domain.PointsDetail;
import me.chanjar.weixin.cp.api.WxCpService;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.test.context.ActiveProfiles;

import javax.annotation.Resource;
import javax.jms.*;

/**
 *
 *
 * @author 谈笑
 * @createTime 2025-09-01 16:18:29 星期一
 */
@ActiveProfiles("dev")
@SpringBootTest
public class ApplicationTest {

	@Resource
	private JmsTemplate jmsTemplate;

	@Resource
	private WxCpService wxCpService;


	@Test
	public void test() {
		PointsDetail detail = new PointsDetail();
		detail.setUserName("TanXiao");
		detail.setDetailPoints(10);
		detail.setDetailName("外部系统");
		detail.setDescription("外部系统");
		this.jmsTemplate.convertAndSend(ActiveMQConstant.Points.DECR_USER_POINTS_QUEUE, detail, message -> {
			message.setStringProperty("userName", detail.getUserName());
			return message;
		});
	}


	public static void main(String[] args) {

		// 连接到ActiveMQ
		ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
		connectionFactory.setUserName("admin");
		connectionFactory.setPassword("admin");
		Connection connection = null;
		try {
			connection = connectionFactory.createConnection();
			connection.start();

			// 创建会话
			Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);

			// 创建目标队列
			Queue queue = session.createQueue(ActiveMQConstant.Points.INCR_USER_POINTS_QUEUE);

			// 创建消息生产者
			MessageProducer producer = session.createProducer(queue);

			// 创建文本消息
			TextMessage message = session.createTextMessage("Hello ActiveMQ!");

			// 设置有效期为5秒（5000毫秒）
			long timeToLive = 5000; // 5000毫秒
			producer.send(message, DeliveryMode.PERSISTENT, Message.DEFAULT_PRIORITY, timeToLive);

			System.out.println("消息发送成功，消息ID: " + message.getJMSMessageID());

		} catch (JMSException e) {
			e.printStackTrace();
		} finally {
			// 关闭连接
			try {
				if (connection != null) {
					connection.close();
				}
			} catch (JMSException e) {
				e.printStackTrace();
			}
		}
	}

}
